<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Role extends Model 
{

    protected $table = 'roles';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function permisions()
    {
        return $this->belongsToMany('Role');
    }

    public function admins()
    {
        return $this->morphedByMany('Admin');
    }

    public function users()
    {
        return $this->morphedByMany('User');
    }

}